/*
 * $QNXLicenseC:
 * Copyright 2016, QNX Software Systems. All Rights Reserved.
 *
 * You must obtain a written license from and pay applicable
 * license fees to QNX Software Systems before you may reproduce,
 * modify or distribute this software, or any work that includes
 * all or part of this software.   Free development licenses are
 * available for evaluation and non-commercial purposes.  For more
 * information visit http://licensing.qnx.com or email
 * licensing@qnx.com.
 *
 * This file may contain contributions from others.  Please review
 * this entire file for other proprietary rights or license notices,
 * as well as the QNX Development Suite License Guide at
 * http://licensing.qnx.com/license-guide/ for other information.
 * $
 */

#include <hw/cypressctrl.h>

#ifndef CYPRESS_SYSINFO_H_
#define CYPRESS_SYSINFO_H_

#define BSWAP_UINT64(x)   ( (((uint64_t)(x) << 56) & 0xff00000000000000ULL) | \
                            (((uint64_t)(x) << 40) & 0xff000000000000ULL) | \
                            (((uint64_t)(x) << 24) & 0xff0000000000ULL) | \
                            (((uint64_t)(x) << 8)  & 0xff00000000ULL) | \
                            (((uint64_t)(x) >> 8)  & 0xff000000ULL) | \
                            (((uint64_t)(x) >> 24) & 0xff0000ULL) | \
                            (((uint64_t)(x) >> 40) & 0xff00ULL) | \
                            (((uint64_t)(x) >> 56) & 0xffULL) )


#define BSWAP_UINT32(x)    ( (((uint32_t)(x) << 24) & 0xff000000U) | \
                            (((uint32_t)(x) << 8) & 0xff0000U) | \
                            (((uint32_t)(x) >> 8) & 0xff00U) | \
                            (((uint32_t)(x) >> 24) & 0xffU) )


#define BSWAP_UINT16(x)    ( (((uint32_t)(x) << 8) & 0xff00U) | \
                            (((uint32_t)(x) >> 8) & 0xffU) )

/* System information Initial Map */
#define MAP_SZH      0x02
#define MAP_SZL      0x03
#define CYDATA_OFSH  0x04
#define CYDATA_OFSL  0x05
#define TEST_OFSH    0x06
#define TEST_OFSL    0x07
#define PCFG_OFSH    0x08
#define PCFG_OFSL    0x09
#define OPCFG_OFSH   0x0A
#define OPCFG_OFSL   0x0B
#define DDATA_OFSH   0x0C
#define DDATA_OFSL   0x0D
#define MDATA_OFSH   0x0E
#define MDATA_OFSL   0x0F

#define SYSTEM_INFORMATION_INITIAL_MAP_SIZE 16

/* Cypress Data Map */
#define TTPIDH        0x00
#define TTPIDL        0x01
#define FW_VER_MAJOR  0x02
#define FW_VER_MINOR  0x03
#define REVCTRL_0     0x04
#define REVCTRL_1     0x05
#define REVCTRL_2     0x06
#define REVCTRL_3     0x07
#define REVCTRL_4     0x08
#define REVCTRL_5     0x09
#define REVCTRL_6     0x0A
#define REVCTRL_7     0x0B
#define BL_VER_MAJOR  0x0C
#define BL_VER_MINOR  0x0D
#define SI_ID3        0x0E
#define SI_ID2        0x0F
#define RESERVED_1    0x10
#define RESERVED_2    0x11
#define MFGID_SZ      0x12
#define MFGID         0x13

#define SYSTEM_INFORMATION_CYPRESS_DATA_SIZE 26

/* Operating Mode Info Map */
#define CMD_OFS           0x00
#define REP_OFS           0x01
#define REP_SZH           0x02
#define REP_SZL           0x03
#define NUM_BTNS          0x04
#define TT_STAT_OFS       0x05
#define OBJ_CFG0          0x06
#define MAX_TCHS          0x07
#define TCH_REC_SIZ       0x08
#define TCH_REC_0         0x09
#define TCH_REC_1         0x0A
#define TCH_REC_2         0x0B
#define TCH_REC_3         0x0C
#define TCH_REC_4         0x0D
#define TCH_REC_5         0x0E
#define TCH_REC_6         0x0F
#define TCH_REC_7         0x10
#define TCH_REC_8         0x11
#define TCH_REC_9         0x12
#define TCH_REC_10        0x13
#define TCH_REC_11        0x14
#define TCH_REC_12        0x15
#define TCH_REC_13        0x16
#define BTN_REC_SIZ       0x17
#define BTN_DIFF_OFS      0x18
#define BTN_DIFF_SIZ      0x19
#define TCH_REC_14        0x1A
#define TCH_REC_15        0x1B
#define TCH_REC_16        0x1C
#define TCH_REC_17        0x1D
#define TCH_REC_18        0x1E
#define TCH_REC_19        0x1F
#define NOISE_DATA_OFS    0x20
#define NOISE_DATA_SZ     0x21
#define RTD_REC_OFS       0x47
#define RTD_REC_SIZ       0x48


/* Power on Self Test Data Map */
#define POST_CODEH        0x00
#define POST_CODEL        0x01

#define SYSTEM_INFORMATION_POST_INFO_SIZE 0x02


/* Panel Configuration Map */
#define ELECTRODES_X      0x00
#define ELECTRODES_Y      0x01
#define LEN_XH            0x02
#define LEN_XL            0x03
#define LEN_YH            0x04
#define LEN_YL            0x05
#define RES_XH            0x06
#define X_ORIGIN    0x80
#define RES_XL            0x07
#define RES_YH            0x08
#define Y_ORIGIN    0x80
#define RES_YL            0x09
#define MAX_ZH            0x0A
#define MAX_ZL            0x0B
#define PANEL_INFO0       0x0C

#define SYSTEM_INFORMATION_PCFG_SIZE                 0x0D

typedef struct cypress_data {
    uint16_t ttpid;                    /* Product id */
    uint8_t fw_ver_major;                /* Firmware Major Version */
    uint8_t fw_ver_minor;                /* Firmware Minor Version */
    uint64_t revctrl;                /* Rev Control Number */
    uint8_t bl_ver_major;                /* Major Version */
    uint8_t bl_ver_minor;                /* Minor Version */
    uint16_t si_id;                    /* Silicon ID */
    uint8_t reserved1[2];
    uint8_t mfgid_sz;                /* Manufacturing ID Size */
    uint8_t mfgid[MAX_MFGID_SZ];            /* Manufacturing ID byte (array) */
    uint8_t reserved2[2];
    uint16_t cyito_ver;                /* CYITO_VER */
    uint8_t ttsp_ver_major;                /* TTSP major version */
    uint8_t ttsp_ver_minor;                /* TTSP minor version*/
    uint8_t device_info;                /* Endianness (bit 0) */
} __attribute__((__packed__)) cypress_data_t;

/* Panel Configuration Data */
typedef struct pcfg_data {
    uint8_t electrodes_x;
    uint8_t electrodes_y;
    uint16_t len_x;
    uint16_t len_y;
    uint16_t res_x;
    uint16_t res_y;
    uint16_t max_z;
    uint8_t panel_info0;
} __attribute__((__packed__)) pcfg_data_t;

typedef struct operating_mode_info {
    uint8_t cmd_ofs;
    uint8_t rep_ofs;
    uint16_t rep_sz;
    uint8_t num_btns;
    uint8_t tt_stat_ofs;
    uint8_t obj_cfg0;
    uint8_t max_tchs;
    uint8_t tch_rec_siz;
    uint8_t tch_rec_0;
    uint8_t tch_rec_1;
    uint8_t tch_rec_2;
    uint8_t tch_rec_3;
    uint8_t tch_rec_4;
    uint8_t tch_rec_5;
    uint8_t tch_rec_6;
    uint8_t tch_rec_7;
    uint8_t tch_rec_8;
    uint8_t tch_rec_9;
    uint8_t tch_rec_10;
    uint8_t tch_rec_11;
    uint8_t tch_rec_12;
    uint8_t tch_rec_13;
    uint8_t btn_rec_siz;
    uint8_t btn_diff_ofs;
    uint8_t btn_diff_siz;
    uint8_t tch_rec_14;
    uint8_t tch_rec_15;
    uint8_t tch_rec_16;
    uint8_t tch_rec_17;
    uint8_t tch_rec_18;
    uint8_t tch_rec_19;
    uint8_t noise_data_ofs;
    uint8_t noise_data_sz;
    uint8_t slider_electrode_x;
    uint8_t slider_electrode_y;
    uint8_t slider_len_xh;
    uint8_t slider_len_xl;
    uint8_t slider_len_yh;
    uint8_t slider_len_yl;
    uint8_t slider_res_xh;
    uint8_t slider_res_xl;
    uint8_t slider_res_yh;
    uint8_t slider_res_yl;
    uint8_t slider_max_zh;
    uint8_t slider_max_zl;
    uint8_t slider_info0; /*reserved*/
    uint8_t force_sensors_num;
    uint8_t accel_sensors_num;
    uint8_t num_slaves;
    uint8_t master_electrode_x;
    uint8_t master_electrode_y;
    uint8_t slave1_electrode_x;
    uint8_t slave1_electrode_y;
    uint8_t slave2_electrode_x;
    uint8_t slave2_electrode_y;
    uint8_t split_tx;
    uint8_t panel_split_tx_index;
    uint8_t panel_split_rx_index;
    uint8_t res_panel_2_xh;
    uint8_t res_panel_2_xl;
    uint8_t res_panel_2_yh;
    uint8_t res_panel_2_yl;
    uint8_t res_offset_1_xh;
    uint8_t res_offset_1_xl;
    uint8_t res_offset_1_yh;
    uint8_t res_offset_1_yl;
    uint8_t res_offset_2_xh;
    uint8_t res_offset_2_xl;
    uint8_t res_offset_2_yh;
    uint8_t res_offset_2_yl;
    uint8_t rtd_rec_ofs;
    uint8_t rtd_rec_siz;
    uint8_t sens_mon_ofs;
    uint8_t sens_mon_siz;
    uint8_t vars_mon_ofs;
    uint8_t vars_mon_siz;
}__attribute__((__packed__)) operating_mode_info_t;

typedef struct customer_data {
    uint8_t *dsgn_data;
    uint8_t *mfg_data;
}__attribute__((__packed__)) customer_data_t;

#endif /* CYPRESS_SYSINFO_H_ */

#if defined(__QNXNTO__) && defined(__USESRCVERSION)
#include <sys/srcversion.h>
__SRCVERSION("$URL: http://svn.ott.qnx.com/product/branches/7.0.0/trunk/hardware/mtouch/cypress/system_information.h $ $Rev: 845042 $")
#endif
